#!/bin/sh
POSTGRESQL_SERVER_VERSION=$( $(locate bin/postgres) -V | egrep -o '[0-9]{1,}\.[0-9]{1,}' )
dpkg --compare-versions $POSTGRESQL_SERVER_VERSION lt 9.3
if [ $? -eq 0 ]; then
    page_size=$(getconf PAGE_SIZE)
    phys_pages=$(getconf _PHYS_PAGES)
    shmall=$(expr $phys_pages / 2)
    shmmax=$(expr $shmall \* $page_size)
    echo "kernel.shmmax=$shmmax" | tee -a /etc/environment
    echo "kernel.shmall=$shmall" | tee -a /etc/environment
    sysctl -w kernel.shmmax=$shmmax
    sysctl -w kernel.shmall=$shmall
fi
